/***************************************************************
   PEP UI CONTROLLER
   Handles tabs, form, example data, and profile generation
****************************************************************/

// Tab switching
function switchTab(tabName) {
  // Hide all tabs
  document.querySelectorAll('.tab-content').forEach(tab => {
    tab.classList.remove('active');
  });
  
  // Deactivate all tab buttons
  document.querySelectorAll('.tab-button').forEach(btn => {
    btn.classList.remove('active');
  });
  
  // Show selected tab
  if (tabName === 'form') {
    document.getElementById('formTab').classList.add('active');
    document.querySelectorAll('.tab-button')[0].classList.add('active');
  } else {
    document.getElementById('infoTab').classList.add('active');
    document.querySelectorAll('.tab-button')[1].classList.add('active');
  }
}

// Fill example data AND auto-generate
function fillExample() {
  document.getElementById('fullName').value = 'Kevin Lynn Brown';
  document.getElementById('birthDate').value = '1968-01-31';
  document.getElementById('birthCity').value = 'Bastrop';
  document.getElementById('birthRegion').value = 'Texas';
  document.getElementById('birthCountry').value = 'United States';
  document.getElementById('birthTime').value = '08:30';
  document.getElementById('birthZone').value = 'CST';
  
  // Auto-generate after filling
  setTimeout(() => {
    generateProfile();
  }, 100);
}

// Clear form
function clearForm() {
  document.getElementById('fullName').value = '';
  document.getElementById('birthDate').value = '';
  document.getElementById('birthCity').value = '';
  document.getElementById('birthRegion').value = '';
  document.getElementById('birthCountry').value = '';
  document.getElementById('birthTime').value = '';
  document.getElementById('birthZone').value = '';
  
  document.getElementById('outputSection').innerHTML = `
    <div class="loading-message">
      ✨ Enter your birth information above and click "Reveal My Purposed Path" to discover your harmonic vocational blueprint.
    </div>
  `;
  
  document.getElementById('actionsBar').style.display = 'none';
}

// Generate profile
function generateProfile() {
  const name = document.getElementById('fullName').value.trim();
  const date = document.getElementById('birthDate').value;
  const city = document.getElementById('birthCity').value.trim();
  const region = document.getElementById('birthRegion').value.trim();
  const country = document.getElementById('birthCountry').value.trim();
  const time = document.getElementById('birthTime').value;
  const zone = document.getElementById('birthZone').value.trim();
  
  // Combine city and region for place
  const place = region ? `${city}, ${region}` : city;
  
  // Show loading
  document.getElementById('outputSection').innerHTML = `
    <div class="loading-message">
      🔮 Calculating your harmonic coordinates...
    </div>
  `;
  
  // Generate profile (small delay for UX)
  setTimeout(() => {
    const profile = window.generatePEP(name, date, place, country, time, zone);
    const html = window.formatPEPOutputModern(profile);
    
    document.getElementById('outputSection').innerHTML = html;
    
    // Show actions bar if profile generated successfully
    if (!profile.error) {
      document.getElementById('actionsBar').style.display = 'flex';
    }
    
    // Scroll to output
    document.getElementById('outputSection').scrollIntoView({ 
      behavior: 'smooth', 
      block: 'start' 
    });
  }, 300);
}

// Scroll to top
function scrollToTop() {
  window.scrollTo({ top: 0, behavior: 'smooth' });
}

// Enter key to submit
document.addEventListener('DOMContentLoaded', function() {
  document.addEventListener('keypress', function(e) {
    if (e.key === 'Enter' && document.getElementById('formTab').classList.contains('active')) {
      generateProfile();
    }
  });
});

console.log('PEP UI Controller Loaded');
